ov.c
main()
{
	int a;

	printf("overlay tester\n");
	a = ovloader("ov1", "first message");
	printf("in main. ovly1 returned %d\n", a);
	a = ovloader("ov2", "second message");
	printf("in main. ovly2 returned %d\n", a);
}

ov1.c
ovmain(a)
char *a;
{
	printf("in ovly1. %s\n", a);
	return(1);
}

ov2.c
ovmain(a)
char *a;
{
	printf("in ovly2. %s\n", a);
	return(2);
}

ovbgn.a65
;:ts=8

	instxt	<zpage.h>

	ext	ovmain_
	ext	_Uorg_,_Uend_

	bss	stack,7
	bss	regs,16
	bss	saveret,4

	entry	.ovbgn
	public	.ovbgn
.ovbgn
	lda	#<_Uorg_	;clear out bss space
	sta	VAL
	lda	#>_Uorg_
	sta	VAL+1
	ldy	#0
loop	tya
	sta	(VAL),Y
	inc	VAL
	bne	skip
	inc	VAL+1
skip	lda	VAL
	cmp	#<_Uend_
	bne	loop
	lda	VAL+1
	cmp	#>_Uend_
	bne	loop

	ldy	#15		;save REGS for ovexit
r1	lda	REGS,Y
	sta	regs,Y
	dey
	bpl	r1

	iny			;save real return address
	lda	(SP),Y
	sta	saveret
	iny
	lda	(SP),Y
	sta	saveret+1
	pla
	sta	saveret+2
	pla
	sta	saveret+3
	clc			;skip over overlay name ptr
	lda	SP
	adc	#2
	sta	SP
	bcc	x1
	inc	SP+1
x1	lda	#>ovret		;set new return address
	sta	(SP),Y
	dey
	lda	#<ovret
	sta	(SP),Y

	ldy	#5		;save stack frame for ovexit
s1	lda	SP,Y
	sta	stack,Y
	dey
	bpl	s1
	tsx
	stx	stack+6

	jsr	ovmain_		;and call the function

	public	ovret
ovret
	sec			;make dummy overlay name ptr
	lda	SP
	sbc	#2
	sta	SP
	bcs	o1
	dec	SP+1
o1	lda	saveret+3	;restore old return address
	pha
	lda	saveret+2
	pha
	ldy	#1
	lda	saveret+1
	sta	(SP),Y
	dey
	lda	saveret
	sta	(SP),Y
	rts

	public	ovexit_
ovexit_
	ldy	#15		;restore REG variables
r2	lda	regs,Y
	sta	REGS,Y
	dey
	bpl	r2

	ldy	#2		;get exit return code
	lda	(SP),Y
	sta	R0
	iny
	lda	(SP),Y
	sta	R0+1

	ldy	#5		;restore stack frame
s2	lda	stack,Y
	sta	SP,Y
	dey
	bpl	s2
	ldx	stack+6
	txs

	jmp	ovret		;and do rest of return from overlay

ovld.c
/* Copyright (C) 1983,84,85 by Manx Software Systems */

#define OVMAGIC	0xf1

struct header {
	int magic;
	unsigned ovaddr;
	unsigned ovsize;
	unsigned ovbss;
	int (*ovbgn)();
};

static char *ovname;

#asm
	instxt	<zpage.h>

	public	ovloader_
ovloader_
	ldy	#2
	lda	(SP),Y
	sta	ovname_
	iny
	lda	(SP),Y
	sta	ovname_+1
;
	jsr	_ovld_
	jmp	(R0)
#endasm

static
_ovld()
{
	int fd;
	auto struct header hdr;
	extern char *_mbot;
	auto char filename[64];
	
	strcpy(filename, ovname);
	for (;;) {
		strcat(filename, ".ovr");
#ifdef PATH
		if (path(filename) && (fd = open(filename, 0)) >= 0)
			break;
#else
		if ((fd = open(filename, 0)) >= 0)
			break;
#endif
		loadabort(10);
	}

	if (read(fd, &hdr, sizeof hdr) != sizeof hdr)
		loadabort(20);

	/* check magic number on overlay file */
	if (hdr.magic != OVMAGIC)
		loadabort(30);

	if (_mbot < (char *)(hdr.ovaddr+hdr.ovsize+hdr.ovbss))
		loadabort(40);

	if (read(fd, hdr.ovaddr, hdr.ovsize) < hdr.ovsize)
		loadabort(50);
	close(fd);
	return hdr.ovbgn;
}

static
loadabort(code)
{
	printf("Error %d loading overlay: %s\n", code, ovname);
	exit(10);
}

#ifdef PATH
#include	<prodos.h>

static
path(file)
char *file;
{
	register char *cp, *tp;
	register int i;
	struct finfo f;
	char buf[64];
	char pbuf[128];
	char *getenv(), *index();

	tp = pbuf;
	*tp = 0;

	if (*file == '/') {		/* don't use path	*/
		strcpy(buf, file);
		goto skip;
	}

	if (cp = getenv("PATH"))		/* get the path	*/
		strcpy(pbuf, cp);
	else {
		*tp = ':';
		tp[1] = 0;
	}
	cp = pbuf;
	while (*cp) {
		tp = index(cp, ':');
		if (tp == 0)
			tp = cp + strlen(cp);
		i = tp - cp;
		strncpy(buf, cp, i);			/* construct a path name */
		buf[i] = 0;
		if (i && buf[i-1] != '/')
			strcat(buf, "/");
		strcat(buf, file);
skip:
		if (getfinfo(buf, &f) == 0) {
			strcpy(file, buf);
			return(1);
		}
		cp = tp;
		if (*cp)
			cp++;
	}
	return(0);
}
#endif

makefile
.SUFFIXES: .c .a65 .r .i
.c.i:
	cci -o $*.i $*.c

.c.r:
	c65 $*.c

.a65.r:
	as65 $*.a65

SRC=  ovld.c ovbgn.a65 ov.c ov1.c ov2.c 

ovly:	ov.bin ov1.ovr ov2.ovr
	@echo "all done!!"

ov.bin:	ov.i ovld.r
	ln65 -t -r +c 400 +d 1000 ov.i ovld.r -lci
	strip65 <ov >ov.bin
	send ov.bin ov 

ov1.ovr:	ov1.i ovbgn.r ov.rsm
	ln65 -t ov1.i ovbgn.r ov.rsm -lci
	send ov1.ovr

ov2.ovr:	ov2.i ovbgn.r ov.rsm
	ln65 -t ov2.i ovbgn.r ov.rsm -lci
	send ov2.ovr

ovly.arc: $(SRC) ovly.bld makefile
	mkarcv ovly.arc < ovly.bld

ovld.r: ovld.c
	c65 -DPATH ovld.c

ovly.bld
ov.c
ov1.c
ov2.c
ovbgn.a65
ovld.c
makefile
ovly.bld
